/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
static char sccsid[] = "@(#)00	1.1  src/avs/fs/mmfs/ts/kernext/gpl-linux/dumpconv.c, mmfs, avs_remp, rempt1d1 10/9/01 13:11:31";

/* 
 * A conversion program for translating output from 
 * the lcrash internal "dump -B" command into binary format.
 * This command expects an input file that was written via
 *
 *   dump -B <address> <bytecount> -w <outfile>
 * 
 * The "dump -B" command produces output such as this
 *
 * 0xc8b63000: 71 82 e9 ac fd d6 bc 3b c0 5f 0d 00 c0 0c 00 00 : q......;._.....
 * 0xc8b63010: 00 00 0c 00 6a 3c 70 30 01 fa 00 00 58 05 38 08 : ....j<p0....X.8
 * 0xc8b63020: 71 82 e9 ac fe d6 bc 3b ef ac 01 00 c1 0c 00 00 : q......;.......
 *
 * Usage:
 *   dumpconv <lcrashDumpFile> <outBinaryFile>
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

int
convert(FILE *fp, int fd)
{
  unsigned int hex;
  unsigned char byte;
  char string[160];
  int i, rc, found;

  while (fgets(string, sizeof(string), fp) != NULL)
  {
    found = 0;
    for (i = 0; i < sizeof(string); i++)
    {
      if (string[i] == ':')
      {
        found = 1;
        break;
      }
    }

    if (!found)
      goto xerror;
    
    found = 0;
    for (i = i + 1; i < sizeof(string); i++)
    {
      if (string[i] == ' ')
        continue;
      if (string[i] == ':')
      {
        found = 1;
        break;
      }

      rc = sscanf(&string[i], "%2x", &hex);
      if (rc == 0)
        goto xerror;
      i = i + 1;  /* read two digits */

      byte = (char)hex;
      write(fd, (void *)&byte, 1);
    }

    if (!found)
      goto xerror;
  }
  return 0;

xerror:
  printf("Confused by: %s\n", string);
  return -1;
}

int
main(int argc, char **argv)
{
  FILE *fp;
  int fd;

  if (argc != 3)
  {
    printf("dumpconv <lcrashDumpFile> <outBinaryFile>\n");
    exit(1);
  }

  fp = fopen(argv[1], "r");
  if (fp == NULL)
  {
    perror("fopen");
    exit(1);
  }

  fd = open(argv[2], O_WRONLY | O_CREAT | O_TRUNC, 0600);
  if (fd < 0)
  {
    perror("open");
    exit(2);
  }

  convert(fp, fd);
}
